#include "BOLTApp.h"
#include "db/BOLTdb.h"
#include "db/BOLTdbConfig.h"

#include "ctrl/BOLTChooser.h"
#include "ctrl/BOLTUser.h"
//#include "ctrl/BOLTReport.h"
#include "ctrl/BOLTControls.h"

#include "BOLTFrm.h"
#include "ctrl/BOLTQuickPicks.h"
#include "wx/statline.h"

enum {
	ID_QP_CLASS=9899,
		ID_QP_LIST,
		ID_QP_TITLE,
		ID_QP_QUERY,
		ID_QP_NEW,
		ID_QP_DELETE,
		ID_QP_SAVE,
		ID_QP_TEST
};

//IMPLEMENT_DYNAMIC_CLASS(BOLTQuickPicks,wxDialog)
BEGIN_EVENT_TABLE(BOLTQuickPicks,wxDialog)
//EVT_CHOICE(ID_QP_CLASS,BOLTQuickPicks::OnClassChoice)
EVT_LISTBOX(ID_QP_LIST,BOLTQuickPicks::OnQueryChoice)
EVT_TEXT(ID_QP_CLASS,BOLTQuickPicks::OnEditClass)
EVT_TEXT(ID_QP_TITLE,BOLTQuickPicks::OnEditTitle)
EVT_TEXT(ID_QP_QUERY,BOLTQuickPicks::OnEditQuery)
EVT_BUTTON(ID_QP_NEW,BOLTQuickPicks::OnNew)
EVT_BUTTON(ID_QP_DELETE,BOLTQuickPicks::OnDelete)
EVT_BUTTON(ID_QP_SAVE,BOLTQuickPicks::OnSave)
EVT_BUTTON(ID_QP_TEST,BOLTQuickPicks::OnTest)
END_EVENT_TABLE()

BOLTQuickPicks::BOLTQuickPicks(wxWindow *parent,BOLTdb *db):
	wxDialog(parent,-1,"Quick Pick Editor",wxDefaultPosition,wxDefaultSize,wxDEFAULT_DIALOG_STYLE|wxRESIZE_BORDER )
	{
		created=false;
		this->db=db;
		dirty=false;
		SetFont(parent->GetFont());
		itemId=0;
		wxBoxSizer *topSizer=new wxBoxSizer(wxHORIZONTAL);
		this->lQuickPicks=new wxListBox(this,ID_QP_LIST);
		this->tTitle=new wxTextCtrl(this,ID_QP_TITLE,"");
		this->tClass=new wxTextCtrl(this,ID_QP_CLASS,"");
		this->tQuery=new wxTextCtrl(this,ID_QP_QUERY,"",wxDefaultPosition,wxDefaultSize,wxTE_MULTILINE|wxHSCROLL);

		wxBoxSizer *vSizer,*hSizer;
		vSizer=new wxBoxSizer(wxVERTICAL);
		vSizer->Add(this->lQuickPicks,1,wxEXPAND);
		hSizer=new wxBoxSizer(wxHORIZONTAL);
		hSizer->Add(new wxButton(this,ID_QP_NEW,"New"),1,wxALIGN_TOP|wxALL,5);
		hSizer->Add(new wxButton(this,ID_QP_DELETE,"Delete"),1,wxALIGN_TOP|wxALL,5);
		vSizer->Add(hSizer,0,wxEXPAND);
		topSizer->Add(vSizer,1,wxEXPAND|wxALL,5);
		vSizer=new wxBoxSizer(wxVERTICAL);
		hSizer=new wxBoxSizer(wxHORIZONTAL);
		hSizer->Add(new wxStaticText(this,-1,"Class"),0);
		hSizer->Add(this->tClass,1);
		vSizer->Add(hSizer,0,wxALL,5);
		hSizer=new wxBoxSizer(wxHORIZONTAL);
		hSizer->Add(new wxStaticText(this,-1,"Title"),0);
		hSizer->Add(this->tTitle,1);
		vSizer->Add(hSizer,0,wxALL,5);
		hSizer=new wxBoxSizer(wxHORIZONTAL);
		hSizer->Add(new wxButton(this,ID_QP_TEST,"Test"),0,wxALIGN_RIGHT);
		hSizer->Add(new wxButton(this,ID_QP_SAVE,"Save"),0,wxALIGN_RIGHT);
		hSizer->Add(new wxButton(this,wxID_CANCEL,"Done"),0,wxALIGN_RIGHT);
		vSizer->Add(hSizer,0);
		vSizer->Add(new wxStaticText(this,-1,"Query"),0,wxALIGN_CENTER);
		vSizer->Add(this->tQuery,1,wxEXPAND);
		topSizer->Add(vSizer,2,wxEXPAND|wxALL,5);
		
//		SetAutoLayout(TRUE);
		SetSizerAndFit(topSizer);
		topSizer->SetSizeHints( this );
		topSizer->Fit( this );

//		SetSize(parent->GetSize());
		Centre();
		created=true;
//		this->FillClassChoice();
//		this->cClass->SetSelection(0);
		FindWindow(ID_QP_SAVE)->Enable(FALSE);
		FindWindow(ID_QP_DELETE)->Enable(FALSE);
		FillQueryList();
		ShowModal();
	}

void BOLTQuickPicks::OnClassChoice(wxCommandEvent &event)
{
	FillQueryList();
}

void BOLTQuickPicks::OnQueryChoice(wxCommandEvent &event)
{

/*	if (FindWindow(ID_QP_SAVE)->IsEnabled())
	{
		if (wxMessageBox("Would you like to save you changes to this Quick Pick ?","Save",wxYES_NO,this)==wxYES)
		{
			this->OnSave(wxCommandEvent(0,0));
		}
	}
*/
	itemId=aId[event.GetSelection()];
	this->tTitle->SetValue(db->GetValue("quickpicks","title",itemId));
	this->tClass->SetValue(db->GetValue("quickpicks","class",itemId));
	this->tQuery->SetValue(db->GetValue("quickpicks","query",itemId));
	FindWindow(ID_QP_SAVE)->Enable(TRUE);
	FindWindow(ID_QP_DELETE)->Enable(TRUE);
}

void BOLTQuickPicks::OnEditTitle(wxCommandEvent &event)
{
dirty=true;
}

void BOLTQuickPicks::OnEditClass(wxCommandEvent &event)
{
dirty=true;
}

void BOLTQuickPicks::OnEditQuery(wxCommandEvent &event)
{
dirty=true;
}

void BOLTQuickPicks::OnNew(wxCommandEvent &event)
{
wxString sClass,tStr;

	itemId=db->NewRecord("quickPicks");
	db->SetValue("quickPicks","title",itemId,"New Query");
//	sClass.Printf("'%s'",cClass->GetStringSelection().c_str());
	db->SetValue("quickPicks","class",itemId,"New");
//	tStr.Printf("insert into quickPicks(id,class,title,query) values(0,'%s','New Query','')",sClass.c_str());
//	db->FreeQuery(db->Query(tStr.c_str(),tStr.Length()));
	FillQueryList();
	this->tTitle->SetValue(db->GetValue("quickpicks","title",itemId));
	this->tClass->SetValue(db->GetValue("quickpicks","class",itemId));
	this->tQuery->SetValue(db->GetValue("quickpicks","query",itemId));
	FindWindow(ID_QP_SAVE)->Enable(TRUE);
	FindWindow(ID_QP_DELETE)->Enable(TRUE);
}

void BOLTQuickPicks::OnDelete(wxCommandEvent &event)
{
	wxString tStr;

	if (itemId>0)
	{
		tStr.Printf("delete from quickpicks where id=%u",itemId);
		db->FreeQuery(db->Query(tStr.c_str(),tStr.Length()));
		FillQueryList();
	}
	FindWindow(ID_QP_SAVE)->Enable(FALSE);
	FindWindow(ID_QP_DELETE)->Enable(FALSE);
}

void BOLTQuickPicks::FillQueryList()
{
	QRY_ID qry;
	void *row;

	wxString classStr,tStr;
	char *tmp;
	RECORD_ID itemId;

	lQuickPicks->Clear();
	aId.Empty();
	tStr="select id,concat(if(class is null,'<empty>',class),':',if(title is null,'<empty>',title)) from quickpicks order by class,title";

	qry=db->Query((char *)tStr.c_str(),tStr.Length());
	if (qry==NULL)
	{
		if (db->IsError()) { LOG_ERROR(db->GetError()); }
		return; 
	}
	int i=0;
	while (row=db->FetchRow(qry))
	{
		if (tmp=db->FetchQueryResult(qry,row,0))
		{ itemId=atoi(tmp); } else { itemId=0; }
		tStr=db->FetchQueryResult(qry,row,1);
		this->lQuickPicks->Append(tStr);
		aId.Add(itemId);
		if (itemId==this->itemId)
		{
			this->lQuickPicks->SetSelection(i);
		}
	}
	db->FreeQuery(qry);

}

void BOLTQuickPicks::FillClassChoice()
{
	QRY_ID qry;
	void *row;

	wxString shortStr,fullStr,tStr;
//	char *tmp;
//	RECORD_ID itemId;
//	cClass->Clear();
	tStr.Printf("select class from quickpicks group by class order by class");

	qry=db->Query((char *)tStr.c_str(),tStr.Length());
	if (qry==NULL)
	{
		if (db->IsError()) { LOG_ERROR(db->GetError()); }
		return; 
	}
//	int i=0;
	while (row=db->FetchRow(qry))
	{
		tStr=db->FetchQueryResult(qry,row,0);
//		this->cClass->Append(tStr);
	}
	db->FreeQuery(qry);

}

void BOLTQuickPicks::OnSave(wxCommandEvent &event)
{
	wxString tStr;
	if (itemId>0)
	{
	tStr.Printf("'%s'",db->EscapeString(tTitle->GetValue().c_str()));
	db->SetValue("quickpicks","title",itemId,tStr.c_str());
	tStr.Printf("'%s'",db->EscapeString(tClass->GetValue().c_str()));
	db->SetValue("quickpicks","class",itemId,tStr.c_str());
	tStr.Printf("'%s'",db->EscapeString(tQuery->GetValue().c_str()));
	db->SetValue("quickpicks","query",itemId,tStr.c_str());
	}
}

void BOLTQuickPicks::OnTest(wxCommandEvent &evt)
{
	BOLTChooser *bc;

	bc=new BOLTChooser(db,this,-1);
	bc->AddQuery(tTitle->GetValue(),tQuery->GetValue());
	bc->GetChoice();
	bc->Destroy();
}
